#include <ultra64.h>
#include "sm64.h"
#include "behavior_data.h"
#include "model_ids.h"
#include "seq_ids.h"
#include "dialog_ids.h"
#include "segment_symbols.h"
#include "level_commands.h"
#include "game/level_update.h"
#include "levels/scripts.h"
#include "actors/common1.h"
#include "make_const_nonconst.h"

#include "areas/1/custom.model.inc.h"

#include "levels/wdw/header.h"
extern u8 _wdw_segment_ESegmentRomStart[];
extern u8 _wdw_segment_ESegmentRomEnd[];

const LevelScript level_wdw_entry[] = {
INIT_LEVEL(),
LOAD_RAW(0x0E, _wdw_segment_ESegmentRomStart, _wdw_segment_ESegmentRomEnd),
LOAD_MIO0(        /*seg*/ 0x0B, _effect_mio0SegmentRomStart, _effect_mio0SegmentRomEnd),
LOAD_MIO0(0xA, _bits_skybox_mio0SegmentRomStart, _bits_skybox_mio0SegmentRomEnd),
LOAD_MIO0(8, _common0_mio0SegmentRomStart, _common0_mio0SegmentRomEnd),
LOAD_RAW(15, _common0_geoSegmentRomStart, _common0_geoSegmentRomEnd),
LOAD_MIO0(5, _group1_mio0SegmentRomStart, _group1_mio0SegmentRomEnd),
LOAD_RAW(12, _group1_geoSegmentRomStart, _group1_geoSegmentRomEnd),
LOAD_MIO0(6, _group14_mio0SegmentRomStart, _group14_mio0SegmentRomEnd),
LOAD_RAW(13, _group14_geoSegmentRomStart, _group14_geoSegmentRomEnd),
ALLOC_LEVEL_POOL(),
MARIO(/*model*/ MODEL_MARIO, /*behParam*/ 0x00000001, /*beh*/ bhvMario),
// Unspecified Models
LOAD_MODEL_FROM_GEO(22,  warp_pipe_geo),
LOAD_MODEL_FROM_GEO(23,  bubbly_tree_geo),
LOAD_MODEL_FROM_GEO(24,  spiky_tree_geo),
LOAD_MODEL_FROM_GEO(25,  snow_tree_geo),
LOAD_MODEL_FROM_GEO(27,  palm_tree_geo),
LOAD_MODEL_FROM_GEO(31,  metal_door_geo),
LOAD_MODEL_FROM_GEO(32,  hazy_maze_door_geo),
LOAD_MODEL_FROM_GEO(34,  castle_door_0_star_geo),
LOAD_MODEL_FROM_GEO(35,  castle_door_1_star_geo),
LOAD_MODEL_FROM_GEO(36,  castle_door_3_stars_geo),
LOAD_MODEL_FROM_GEO(37,  key_door_geo),
LOAD_MODEL_FROM_GEO(38,  castle_door_geo),
// LOAD_MODEL_FROM_DL(132, 0x08025f08, 4),
// LOAD_MODEL_FROM_DL(158, 0x0302c8a0, 4),
// LOAD_MODEL_FROM_DL(159, 0x0302bcd0, 4),
// LOAD_MODEL_FROM_DL(161, 0x0301cb00, 4),
// LOAD_MODEL_FROM_DL(164, 0x04032a18, 4),
// LOAD_MODEL_FROM_DL(201, 0x080048e0, 4),
// LOAD_MODEL_FROM_DL(218, 0x08024bb8, 4),
// LOAD_MODEL_FROM_GEO(226, 0x07007070),
// LOAD_MODEL_FROM_GEO(227, 0x07008dc0),
// LOAD_MODEL_FROM_GEO(228, 0x0700a090),
// LOAD_MODEL_FROM_GEO(229, 0x0700bfe0),
// LOAD_MODEL_FROM_GEO(230, 0x0700e3d0),
// LOAD_MODEL_FROM_GEO(231, 0x0700efd0),
// LOAD_MODEL_FROM_GEO(232, 0x07010780),
// LOAD_MODEL_FROM_GEO(233, 0x07011ab0),
// LOAD_MODEL_FROM_GEO(249, 0x07004a10),
// LOAD_MODEL_FROM_GEO(250, 0x07002a20),
JUMP_LINK(script_func_global_1),
JUMP_LINK(script_func_global_2),
JUMP_LINK(script_func_global_15),
JUMP_LINK(local_area_wdw_1_),
FREE_LEVEL_POOL(),
MARIO_POS(/* area */ 1, /* yaw */ 0, /* pos */ 0, 0, 0),
CALL(/*arg*/ 0, /*func*/ lvl_init_or_update),
CALL_LOOP(/*arg*/ 1, /*func*/ lvl_init_or_update),
CLEAR_LEVEL(),
SLEEP_BEFORE_EXIT(/*frames*/ 1),
EXIT(),
};

const LevelScript local_area_wdw_1_[] = {
AREA(1, Geo_wdw_1_0x164d0a0),
TERRAIN(col_wdw_1_0xe044f00),
SET_BACKGROUND_MUSIC(0, 38),
TERRAIN_TYPE(0),
JUMP_LINK(local_objects_wdw_1_),
JUMP_LINK(local_warps_wdw_1_),
END_AREA(),
RETURN()
};

const LevelScript local_objects_wdw_1_[] = {
OBJECT_WITH_ACTS(0, 797, 1524, -1025, 0, 135, 0, 0xa0000,  bhvSpinAirborneWarp, 31),
OBJECT_WITH_ACTS(250, 3735, 400, -13377, 0, 0, 0, 0x0,  Bhv_Custom_0x130056bc, 31),
OBJECT_WITH_ACTS(103, 1256, 2475, -12653, 0, 0, 0, 0x0,  bhvWhompKingBoss, 31),
OBJECT_WITH_ACTS(249, 2942, 400, -12062, 0, 0, 0, 0x0,  Bhv_Custom_0x130056e8, 31),
OBJECT_WITH_ACTS(31, 5311, 500, -1428, 0, 90, 0, 0x0,  bhvDoor, 31),
OBJECT_WITH_ACTS(31, 13533, 500, -10307, 0, 0, 0, 0x0,  bhvDoor, 31),
OBJECT_WITH_ACTS(31, 9557, 500, -10315, 0, 0, 0, 0x0,  bhvDoor, 31),
OBJECT_WITH_ACTS(0, 13159, -840, -13923, 0, 0, 0, 0x1000000,  bhvHiddenStar, 31),
OBJECT_WITH_ACTS(137, 14674, 3000, -8865, 0, 0, 0, 0xb0000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(122, 1708, 5040, -1217, 0, 0, 0, 0x3000000,  bhvStar, 31),
OBJECT_WITH_ACTS(122, 15793, 2707, -4125, 0, 0, 0, 0x4000000,  bhvStar, 31),
OBJECT_WITH_ACTS(0, 11041, 1500, -14261, 0, 0, 0, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(0, 14727, 1900, -10482, 0, 0, 0, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(0, 12517, -1085, -12408, 0, 0, 0, 0x0,  bhvHiddenStarTrigger, 31),
OBJECT_WITH_ACTS(0, 4901, 1110, -4481, 0, 0, 0, 0x5000000,  bhvHiddenRedCoinStar, 31),
OBJECT_WITH_ACTS(215, 4961, 640, -7252, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 4565, 3900, -746, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 13255, 2215, -7329, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 5545, 1710, -5843, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 7983, 2700, -10466, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 14677, 2550, -13052, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 8230, 1029, -8893, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(215, 3758, 3130, -13974, 0, 0, 0, 0x0,  bhvRedCoin, 31),
OBJECT_WITH_ACTS(116, 14736, 2080, -10473, 0, 0, 0, 0x0,  bhvOneCoin, 31),
OBJECT_WITH_ACTS(116, 12523, -875, -12412, 0, 0, 0, 0x0,  bhvOneCoin, 31),
OBJECT_WITH_ACTS(116, 11035, 1710, -14272, 0, 0, 0, 0x0,  bhvOneCoin, 31),
OBJECT_WITH_ACTS(89, 13188, 2125, -8781, 0, 0, 0, 0x0,  bhvHeaveHo, 31),
OBJECT_WITH_ACTS(89, 13198, 2125, -5681, 0, 0, 0, 0x0,  bhvHeaveHo, 31),
OBJECT_WITH_ACTS(89, 11302, 2000, -4808, 0, 0, 0, 0x0,  bhvHeaveHo, 31),
OBJECT_WITH_ACTS(89, 9180, 1875, -5459, 0, 0, 0, 0x0,  bhvHeaveHo, 31),
OBJECT_WITH_ACTS(89, 9123, 1875, -7499, 0, 0, 0, 0x0,  bhvHeaveHo, 31),
OBJECT_WITH_ACTS(223, 4726, 500, -4854, 0, 0, 0, 0x0,  bhvChuckya, 31),
OBJECT_WITH_ACTS(223, 11479, 500, -1649, 0, 0, 0, 0x0,  bhvChuckya, 31),
OBJECT_WITH_ACTS(223, 12043, 500, -6936, 0, 0, 0, 0x0,  bhvChuckya, 31),
OBJECT_WITH_ACTS(223, 13035, 500, -13088, 0, 0, 0, 0x0,  bhvChuckya, 31),
OBJECT_WITH_ACTS(223, 3045, 3350, -6608, 0, 0, 0, 0x0,  bhvChuckya, 31),
OBJECT_WITH_ACTS(0, 2570, 500, -9981, 0, 0, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 9264, 1875, -6750, 0, 0, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 9616, 500, -1553, 0, 270, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 5150, 3350, -3724, 0, 0, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 2414, 3350, -7939, 0, 0, 0, 0x20000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 9649, 575, -12178, 0, 0, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 13287, -1670, -12727, 0, 0, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 14714, 500, -3325, 0, 0, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 6349, 2465, -10852, 0, 90, 0, 0x0,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(129, 5560, 500, -6302, 0, 0, 0, 0x0,  bhvBreakableBox, 31),
OBJECT_WITH_ACTS(129, 5560, 500, -6503, 0, 0, 0, 0x0,  bhvBreakableBox, 31),
OBJECT_WITH_ACTS(103, 6164, 500, -12655, 0, 0, 0, 0x0,  bhvSmallWhomp, 31),
OBJECT_WITH_ACTS(103, 4449, 3350, -6644, 0, 0, 0, 0x0,  bhvSmallWhomp, 31),
OBJECT_WITH_ACTS(0, 11042, 1125, -11218, 0, 0, 0, 0x110000,  bhvCoinFormation, 31),
OBJECT_WITH_ACTS(0, 14764, 2585, -8653, 0, 270, 0, 0x0,  bhvFlamethrower, 31),
OBJECT_WITH_ACTS(0, 14768, 2585, -9079, 0, 270, 0, 0x0,  bhvFlamethrower, 31),
OBJECT_WITH_ACTS(188, 9618, 575, -14501, 0, 0, 0, 0x0,  bhvBobomb, 31),
OBJECT_WITH_ACTS(0, 4175, 500, -6453, 0, 0, 0, 0x0,  bhvGoombaTripletSpawner, 31),
OBJECT_WITH_ACTS(0, 1494, 500, -8773, 0, 0, 0, 0x0,  bhvGoombaTripletSpawner, 31),
OBJECT_WITH_ACTS(137, 13864, 1385, -2650, 0, 0, 0, 0x60000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(137, 9625, 575, -13387, 0, 0, 0, 0x70000,  bhvExclamationBox, 31),
OBJECT_WITH_ACTS(180, 4814, 2580, -9647, 0, 0, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(180, 13258, 2580, -4829, 0, 0, 0, 0x0,  bhvFireSpitter, 31),
OBJECT_WITH_ACTS(89, 12966, -1550, -13827, 0, 0, 0, 0x0,  bhvHeaveHo, 31),
OBJECT_WITH_ACTS(24, 5045, 500, -5975, 0, 0, 0, 0x0,  bhvTree, 31),
OBJECT_WITH_ACTS(223, 10964, 1250, -12635, 0, 0, 0, 0x0,  bhvChuckya, 31),
OBJECT_WITH_ACTS(0, 10, 4, 297, 0, 0, 20, 3,  RM_Scroll_Texture, 31),
RETURN()
};

const LevelScript local_warps_wdw_1_[] = {
WARP_NODE(10, 9, 1, 0, 0),
WARP_NODE(240, 6, 3, 41, 0),
WARP_NODE(241, 6, 3, 51, 0),
RETURN()
};
